/*
Replicates Figure 1: Average and median Monetary Policy credibility index for Emerging and 
Advanced Economies. 

*/

clear
cls

//Adjust this this directory: 
cap cd "Replication_pkg/Data_programs/Figure 1"


* Load all data and generate variables
graph set window fontface "Times New Roman"

use "Data_fig1.dta", clear
sort year
* IAPOC Average and Median
line iapoc year if EM==0, lcolor(blue) lwidth(thick) || ///
(line med_iapoc year if EM==0, lcolor(blue) lp(-) lwidth(thick)) || ///
(line iapoc year if EM==1, lcolor(red) lwidth(thick)) || ///
(line med_iapoc year if EM==1, lcolor(red) lp(-) lwidth(thick)), ///
xtitle("") xla(2007(1)2021,  labsize(small)) xlab(, nogrid) ///
ytitle("Policy Credibility Index") ylab(, nogrid) ///
	legend(pos(6) label (1 "AE Average") label (2 "AE Median") label (3 "EM Average") label (4 "EM Median") cols(2)) plotregion(style(none)) 
 
graph export "fig1.pdf", replace 


//To excel 
export excel using "Figure1.xlsx", firstrow(variables) sheet("Data Fig 1") replace 

